//CTF_SkinForce.c - routine to force player skin

#include "g_local.h"

void ClientUserinfoChanged (edict_t *ent, char *userinfo)
{
	char	*s;
//	char	*fog;
	int		playernum;
	char	*extras;
    int     fIgnoreName = 0,a;

	// client exe version
	s = Info_ValueForKey (userinfo, "ver");
	if (strlen(s))
		ent->client->pers.version = atoi(s);
	else	// assume client is old version
		ent->client->pers.version = 100;

	s = Info_ValueForKey (userinfo, "ip");
	if (strlen(s))
		strncpy(ent->client->pers.ip,s,31);

	// check for malformed or illegal info strings
	if (!Info_Validate(userinfo))
	{
		// strcpy (userinfo, "\\name\\badinfo\\skin\\male_thug/018 016 010\\extras\\0");
		strcpy (userinfo, "\\name\\badinfo\\skin\\male_thug/009 019 017\\extras\\0");
	}

	if (!ent->client->resp.enterframe) {
		Info_SetValueForKey(userinfo,"msg","0");
	}

	// set name
    /* Standard Logging - don't change name */
/*    if( '\0' != ent->client->pers.netname[0] )
    {
        Info_SetValueForKey (userinfo, "name", ent->client->pers.netname);
        fIgnoreName = 1;
    }
*/    
	// set name
	s = Info_ValueForKey (userinfo, "name");
	if (strchr(s,'%')) {
		char *s2;
		while (s2=strchr(s,'%')) *s2=' ';
		Info_SetValueForKey (userinfo, "name", s);
	}
	for (a=strlen(s)-1;a>=0 && s[a]<33;a--) ;
	if (a==-1) {
//		if( '\0' != ent->client->pers.netname[0] )
//			fIgnoreName = 1;
//		else
			s=NAME_BLANK_STR;
	} else {
	s[a+1]=0;

    // Standard Logging - stop name clashes
    if( !fIgnoreName )
    {
        edict_t		*cl_ent;
        unsigned int i;

        for (i=0 ; i<game.maxclients ; i++)
        {
            cl_ent = g_edicts + 1 + i;
            if( cl_ent->inuse &&
                (cl_ent != ent) &&
                !strcmp(cl_ent->client->pers.netname, s) )
            {
				edict_t *thinker;
				thinker = G_Spawn();
				thinker->think = nameclash_think;
				thinker->nextthink = level.time + 2 + random()*2;
				thinker->owner = ent;
//                if( '\0' != ent->client->pers.netname[0] )
  //                  fIgnoreName = 1;
    //            else
                    s = NAME_CLASH_STR;

                Info_SetValueForKey (userinfo, "name", s);
            }
        }
    }
	}
    // Standard Logging

    if( !fIgnoreName )
    {
        // start - Standard Logging
        // Has the player got a name
/*        if( strlen(ent->client->pers.netname) )
        {
            // has the name changed
            if( strcmp( ent->client->pers.netname, s ) )
            {
                // Standard Logging -  log player rename
                sl_LogPlayerRename( &gi,
                                    ent->client->pers.netname,
                                    s,
                                    level.time );
            }
        }
*/        // end - Standard Logging

        strncpy (ent->client->pers.netname, s, sizeof(ent->client->pers.netname)-1);
    }

	if (CheckNameBan(s))
		KICKENT(ent,"%s is being kicked because they're banned!\n");

	// check maxrate
	s=Info_ValueForKey (userinfo, "rate");
	if (s[0] && (a=atoi(s))) {
		if ((int)maxrate->value && a>(int)maxrate->value) {
			if (!ent->client->resp.enterframe) {
				edict_t *thinker;
				thinker = G_Spawn();
				thinker->think = maxrate_think;
				thinker->nextthink = level.time + 2 + random()*2;
				thinker->owner = ent;
			} else {
				gi.cprintf(ent, PRINT_HIGH, "Server restricting rate to %d\n",(int)maxrate->value);
			}
			Info_SetValueForKey( userinfo, "rate", va("%i", (int)maxrate->value) );
		}
	}

	// set skin
	s=Info_ValueForKey (userinfo, "skin");
	if (strchr(ent->skins,'/') && level.framenum<(ent->move_frame+10)) {
		strcpy(s, ent->skins);
	}

	// Ridah, HACK for teamplay demo, set skins manually
	if (deathmatch->value && teamplay->value && ent->client->pers.team)
	{
		// NOTE: skin order is "HEAD BODY LEGS"
		char *skin, *body, *legs, *head;
		char tempstr[MAX_QPATH];
		int i, valid, model_index;

		// Hard-coded skin sets for each model

		static char *valid_models[] = { "female_chick", "male_thug", "male_runt", NULL };
// ordering here is {"LEGS", "BODY", "HEAD"}
//*************These are team-swapped compared to CTF**************
		static char *valid_thug_skinsets[2][3][3] =
		{
				{{"ct1","ct1","ct1"}, {"ct2","ct2","ct2"}, {"ct3","ct3","ct3"}},	// Team 1
				{{"rc1","rc1","rc1"}, {"rc2","rc2","rc2"}, {"rc3","rc3","rc3"}}		// Team 2
		};
		static char *valid_runt_skinsets[2][2][3] =
		{
				{{"ct4","ct4","ct4"}, {"ct5","ct5","ct5"}},		// Team 1
				{{"rc4","rc4","rc4"}, {"rc5","rc5","rc5"}}		// Team 2
		};
		static char *valid_bitch_skinsets[2][2][3] =
		{
				{{"ct6","ct6","ct6"}, {"ct7","ct7","ct7"}},		// Team 1
				{{"rc6","rc6","rc6"}, {"rc7","rc7","rc7"}}		// Team 2
		};

// make sure they are using one of the standard models
		valid = false;
		i = 0;
		strcpy( tempstr, s );
//CDEATH DEBUG
//		gi.bprintf(PRINT_HIGH, "CLIENTUSERINFOCHANGED Entry: %s\n", tempstr);
		skin = strrchr( tempstr, '/' );

		if (!skin)
		{	// invalid model, so assign a random one
			model_index = rand()%3;
			strcpy( tempstr, valid_models[model_index] );

			// also recreate a new skin for "s"
			strcpy( s, tempstr );
			strcat( s, "/001 001 001" );

			valid = true;
		}
		else
		{
			skin[0] = '\0';

			while (valid_models[i])
			{
				if (!Q_stricmp( tempstr, valid_models[i] ))
				{
					valid = true;
					model_index = i;
					break;
				}

				i++;
			}
		}

		if (!valid)
		{	// assign a random model
			model_index = -1;

			// look for a gender match
			while (valid_models[i])
			{
				if (!strncmp( tempstr, valid_models[i], 4 ))
				{
					model_index = i;
					strcpy( tempstr, valid_models[model_index] );
					break;
				}

				i++;
			}

			if (model_index < 0)
			{
				model_index = rand()%3;
				strcpy( tempstr, valid_models[model_index] );
			}
		}

		// At this point, tempstr = model only (eg. "male_thug")

		// check that skin is valid
		skin = strrchr( s, '/' ) + 1;
		skin[3] = skin[7] = '\0';

		head = &skin[0];
		body = &skin[4];
		legs = &skin[8];

		valid = false;

		switch(model_index)
		{
			case 1://THUG
			{
				for (i=0; i<3; i++)
				{
					if (	!Q_stricmp( body, valid_thug_skinsets[ent->client->pers.team-1][i][1] )
						&&	!Q_stricmp( legs, valid_thug_skinsets[ent->client->pers.team-1][i][0] )
						&&	!Q_stricmp( head, valid_thug_skinsets[ent->client->pers.team-1][i][2] ))
					{
						valid = true;
						break;
					}
				}
				if (!valid)
				{	// Assign a random skin for this model
					i = rand()%3;

					strcpy( head, valid_thug_skinsets[ent->client->pers.team-1][i][2] );
					strcpy( body, valid_thug_skinsets[ent->client->pers.team-1][i][1] );
					strcpy( legs, valid_thug_skinsets[ent->client->pers.team-1][i][0] );
				}
				break;
			}
			case 2://RUNT
			{
				for (i=0; i<1; i++)
				{
					if (	!Q_stricmp( body, valid_runt_skinsets[ent->client->pers.team-1][i][1] )
						&&	!Q_stricmp( legs, valid_runt_skinsets[ent->client->pers.team-1][i][0] )
						&&	!Q_stricmp( head, valid_runt_skinsets[ent->client->pers.team-1][i][2] ))
					{
						valid = true;
						break;
					}
				}
				if (!valid)
				{	// Assign a random skin for this model
					i = 0;//rand()%2;

					strcpy( head, valid_runt_skinsets[ent->client->pers.team-1][i][2] );
					strcpy( body, valid_runt_skinsets[ent->client->pers.team-1][i][1] );
					strcpy( legs, valid_runt_skinsets[ent->client->pers.team-1][i][0] );
				}
				break;
			}
			case 0://BITCH
			{
				for (i=0; i<2; i++)
				{
					if (	!Q_stricmp( body, valid_bitch_skinsets[ent->client->pers.team-1][i][1] )
						&&	!Q_stricmp( legs, valid_bitch_skinsets[ent->client->pers.team-1][i][0] )
						&&	!Q_stricmp( head, valid_bitch_skinsets[ent->client->pers.team-1][i][2] ))
					{
						valid = true;
						break;
					}
				}
				if (!valid)
				{	// Assign a random skin for this model
					i = rand()%2;

					strcpy( head, valid_bitch_skinsets[ent->client->pers.team-1][i][2] );
					strcpy( body, valid_bitch_skinsets[ent->client->pers.team-1][i][1] );
					strcpy( legs, valid_bitch_skinsets[ent->client->pers.team-1][i][0] );
				}
				break;
			}
		}


		skin[3] = skin[7] = ' ';

		// paste the skin into the tempstr
		strcat( tempstr, "/" );
		strcat( tempstr, skin );

		Info_SetValueForKey( userinfo, "skin", tempstr );
		strncpy(ent->skins,tempstr,31);
//CDEATH DEBUG
//		gi.bprintf(PRINT_HIGH, "CLIENTUSERINFOCHANGED Exit: %s\n", tempstr);
	}
	else if (!deathmatch->value)	// enforce thug with single player skin set
	{
		static char *singleplayerskin = "male_thug/018 016 010";

		Info_SetValueForKey( userinfo, "skin", singleplayerskin );
	} else
		strncpy(ent->skins,s,31);

	// now check it again after the filtering, and set the Gender accordingly
	s=Info_ValueForKey (userinfo, "skin");
	if ((strstr(s, "female") == s))
		ent->gender = GENDER_FEMALE;
	else if ((strstr(s, "male") == s) || (strstr(s, "thug")))
		ent->gender = GENDER_MALE;
	else
		ent->gender = GENDER_NONE;

	extras=Info_ValueForKey (userinfo, "extras");

	playernum = ent-g_edicts-1;

	// combine name and skin into a configstring
	gi.configstring (CS_PLAYERSKINS+playernum, va("%s\\%s %s", ent->client->pers.netname, s, extras) );

	// fov
	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}

	// handedness
	s = Info_ValueForKey (userinfo, "hand");
	if (s[0]) ent->client->pers.hand = atoi(s);

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, MAX_INFO_STRING-1);
}

